ScriptName RF:FuelTankNewHandler Extends ActiveMagicEffect

RF:FuelHandlerQuest Property FuelManager Auto Mandatory Const

Potion Property TankHigh Mandatory Const Auto
{ Indicated by duration 7 }
Potion Property TankMed Mandatory Const Auto
{ Indicated by duration 8 }
Potion Property TankLow Mandatory Const Auto
{ Indicated by duration 9 }

MiscObject Property EmptyTank Mandatory Const Auto

Message Property FailMessage Mandatory Const Auto
{ This will show if we are not in our ship }
Message Property WrongLocationMessage Mandatory Const Auto
{ This may or may not display when we did not have the fuel in our cargo hold}
Message Property SuccessMessage Mandatory Const Auto
{ This will show when refueling completes.}
Message Property StartMessage Mandatory Const Auto
{ Show if we need fuel and are good to go }
Message Property WasteMessage Mandatory Const Auto
{ Show if we didn't need the item}

GlobalVariable Property _RF_State_IsRefuelingOK Mandatory Const Auto
{ This is only set to 1 while using smartfuel now }

bool RightLocation = False
bool Overflow = False
Float FillAmount = 1.0

Potion TheTank

Function GetTheTank(float afDuration)
    If afDuration == 7.0
        TheTank = TankHigh
    ElseIf afDuration  == 8.0
        TheTank = TankMed
    ElseIf afDuration == 9.0
        TheTank = TankLow
    EndIF
EndFunction

; 0.7 has to be run from the hold with _RF_STATE
Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, float afMagnitude, float afDuration)
    If FuelManager.ModRunning()
        GetTheTank(afDuration) ; Need this before we can cancel so we return the right thing
        float FuelNeeded = FuelManager.CheckFuelAmount(true)
        If _RF_State_IsReFuelingOK.GetValue() == 1 ; This will fail if we eat the item manually
            FillAmount = afMagnitude ; Since this doesn't directly fucking do anything we have to script the fill. Thanks Todd!!!
            Overflow = ( ( FillAmount / 3 ) > FuelNeeded ) as bool ; This will fail if we need less than 1/3 of what is in the canister. May skip this
            If !Overflow
                StartMessage.Show(FuelManager.CheckFuelAmount() as int)
                RightLocation = True
            Else
                RightLocation = False
                Dispel()
            EndIF
        Else
            RightLocation = False
            Dispel()
        EndIF
        FuelManager.QuickTrace("FuelTankNewHandler got OverflowCancel " + Overflow + " from " + FuelNeeded + " vs " + afMagnitude + " and Loc " + RightLocation + " from Global " + _RF_State_IsRefuelingOK.GetValue() ) 
    EndIf
EndEvent

; Since this is purely scripted we can make it work exactly like ship parts
Event OnEffectFinish(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, float afMagnitude, float afDuration)
    If Overflow
        WasteMessage.Show()
        FuelManager.HandleReturn(TheTank, true)
        FuelManager.QuickTrace("FuelTankNewHandler failed in Overflow state")
    Else
        If RightLocation
            FuelManager.Realfuel(false, afMagnitude, true) ; Maybe this is the culprit. We can only call this from smartfuel anyways
            SuccessMessage.Show(FuelManager.CheckFuelAmount() as int)
            FuelManager.StartFuelSound(false)
            FuelManager.HandleReturn(EmptyTank, true, true)
            FuelManager.QuickTrace("FuelTankNewHandler succeeded")
        Else
            WrongLocationMessage.Show()
            FuelManager.HandleReturn(TheTank, false)
            Game.RequestHUDRolloverRefresh()
            FuelManager.QuickTrace("FuelTankNewHandler failed in Location state")
        EndIf
    EndIf

EndEvent